﻿using System.Collections.Generic;
using VA.TMP.Integration.Schema.VirtualMeetingRoom;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Delete
{
    /// <summary>
    /// Serialize VMR step.
    /// </summary>
    public class SerializeDeleteVmrStep : FilterBase<VirtualMeetingRoomDeleteStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VirtualMeetingRoomDeleteStateObject state)
        {
            state.VirtualMeetingRoomDelete = new VirtualMeetingRoomDeleteType
            {
                Version = "1.0",
                AppointmentId = state.AppointmentId.ToString(),
                MiscData = state.MiscDataForRequest
            };

            state.SerializedVirtualMeetingRoomDelete = Shared.PipelineUtilities.SerializeInstance(state.VirtualMeetingRoomDelete, new List<string> { "vmr" }, 
                new List<string> { "http://DNS   /vyopta/schemas/exchange/VirtualMeetingRoom/1.0" });
        }
    }
}